/*
 * Decompiled with CFR 0.152.
 */
package util;

import filenet.vw.toolkit.utils.VWCommandLineArgs;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import util.IVWBuildInfo;

public class VWBuildInfoHelper {
    public static final String CLASS_NAME = "className";
    public static final String JAR_FILE_PATH = "jarFilePath";

    public static void main(String[] args) {
        try {
            VWCommandLineArgs cmdlineArgs = new VWCommandLineArgs(args);
            if (cmdlineArgs != null) {
                String className = cmdlineArgs.getParameter(CLASS_NAME);
                String jarFilePath = cmdlineArgs.getParameter(JAR_FILE_PATH);
                VWBuildInfoHelper testApp = new VWBuildInfoHelper();
                String varVersion = testApp.getJarVersion(className, jarFilePath);
                System.out.println("Jar version = " + varVersion);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String getJarVersion(String className, String jarFilePath) {
        try {
            ClassLoader customCL = this.getCustomClassLoader(jarFilePath);
            if (customCL != null && className != null && className.length() > 0) {
                Object versionClass;
                if ((className = className.replace('/', '.')).endsWith(".class")) {
                    className = className.substring(0, className.length() - 6);
                }
                if ((versionClass = customCL.loadClass(className).newInstance()) != null && versionClass instanceof IVWBuildInfo) {
                    return ((IVWBuildInfo)versionClass).getJarVersion();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    protected ClassLoader getCustomClassLoader(String jarFilePath) {
        if (jarFilePath != null && jarFilePath.length() > 0) {
            try {
                File jarFile = new File(jarFilePath.trim());
                URL[] urls = new URL[]{jarFile.toURL()};
                return new URLClassLoader(urls, this.getClass().getClassLoader());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return this.getClass().getClassLoader();
    }
}

